% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{auc}
\alias{auc}
\title{Compute the Area Under the \link{pp_plot} Curve
Calculates the area under the \code{pp} curve. The area under the curve is 
also a useful effect-size like statistic, representing the probability that 
a randomly selected individual from the \code{x} distribution will have a 
higher value than a randomly selected individual from the \code{y} 
distribution.}
\usage{
auc(data, formula, ref_group = NULL, rename = TRUE)
}
\arguments{
\item{data}{The data frame used for estimation - ideally structured in a tidy 
format.}

\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups. Additional variables 
can be included with \code{+} to produce separate estimates by the secondary 
or tertiary variables of interest (e.g., \code{out ~ group + characteristic1 
+ characteristic2}).}

\item{ref_group}{Optional. A character vector or forumla listing the 
reference group levels for each variable on the right hand side of the 
formula, supplied in the same order as the formula. Note that if using the
formula version, levels that are numbers, or include hyphens, spaces, etc., 
should be wrapped in back ticks (e.g., 
\code{ref_group = ~ Active + `Non-FRL`}, or \code{ref_group = ~`8`}). When 
in doubt, it is safest to use the back ticks, as they will not interfere 
with anything if they are not needed. See examples below for more details.}

\item{rename}{Used primarily for internal purposes. Should the column 
names be renamed to reference the focal and reference groups? Defaults to
\code{TRUE}.}
}
\value{
By default the area under the curve for all possible pairings of
the grouping factor are returned.
}
\description{
Compute the Area Under the \link{pp_plot} Curve
Calculates the area under the \code{pp} curve. The area under the curve is 
also a useful effect-size like statistic, representing the probability that 
a randomly selected individual from the \code{x} distribution will have a 
higher value than a randomly selected individual from the \code{y} 
distribution.
}
\examples{

# Calculate AUC for all pairwise comparisons
auc(star, reading ~ condition) 

# Report only relative to regular-sized classrooms
auc(star, 
    reading ~ condition, 
    ref_group = "reg")

# Report by ELL and FRL groups for each season, compare to non-ELL students
# who were not eligible for free or reduced price lunch in the fall (using
# the formula interface for reference group referencing).
\dontrun{
auc(benchmarks, 
      math ~ ell + frl + season,
      ref_group = ~`Non-ELL` + `Non-FRL` + Fall)

# Same thing but with character vector supplied, rather than a formula
auc(benchmarks, 
      math ~ ell + frl + season,
      ref_group = c("Non-ELL", "Non-FRL", "Fall"))
}

}
