% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/participants_book.R
\name{participants_book}
\alias{participants_book}
\title{Generate a participants' book}
\usage{
participants_book(
  df,
  idvar = "id",
  obsnovar = "obsno",
  focusvar = NULL,
  timevar = NULL,
  validvar = NULL,
  compliancevar = NULL,
  obsno_max = NULL,
  list_behaviors = c("min_date", "max_date", "nb_answer", "compliance"),
  list_stats = c("mean", "sd", "n_length", "n_unique"),
  viz = list(c("ts", "hist")),
  html_output = NULL,
  kable_out = TRUE,
  min_max_regularize = TRUE
)
}
\arguments{
\item{df}{A dataframe containing the participant data}

\item{idvar}{The name of the column in the dataframe that represents the participant identifier}

\item{obsnovar}{The name of the column in the dataframe that represents the beep number}

\item{focusvar}{A vector of variable names representing the variables of interest in the dataframe}

\item{timevar}{The name of the column in the dataframe that represents the timestamp}

\item{validvar}{The name of the column in the dataframe that represents the validity of responses}

\item{compliancevar}{The name of the column in the dataframe that represents the compliance rate (alternatively, if NULL, the compliance score is computed as the number of rows divided by obsno_max)}

\item{obsno_max}{The maximum number of beeps for computing the compliance score (only used if compliancevar is NULL)}

\item{list_behaviors}{A vector indicating the types of participants' response behavior information to display. Valid options are "min_date", "max_date", "nb_answer", and "compliance".}

\item{list_stats}{A vector indicating the types of descriptive statistics to display. Valid options are "mean", "sd", "range", "n_length", and "n_unique".}

\item{viz}{A vector indicating the visualization type to display for each focusvar variable. Valid options are "ts" (time series plot) and "hist" (histogram).}

\item{html_output}{Define a file name (e.g., "path/to/participant_book.html") to create an html output version of the participant book.}

\item{kable_out}{When TRUE, output is in kable version. If FALSE, use DT package.}

\item{min_max_regularize}{Whether to regularize the y-axis or x-axis limits across plots based on the global minimum and maximum values. Default is TRUE.}
}
\value{
A kable or datatable object (from the DT package), representing the participants' book.
}
\description{
The 'participants_book()' function creates a participants' book, which provides a concise summary of participants' data
from an intensive longitudinal study, such as Experience Sampling Method (ESM).
The book is generated using the DT package, and each participant is represented by a row in the table.
The participants' book displays various information about participants' response behaviors, including compliance rate,
study duration, and start time. Additionally, it provides descriptive statistics and time series plots for the variables of interest.
See an example here: \url{https://preprocess.esmtools.com/pages/90_Participant_book.html}.
}
\examples{
\donttest{
 participants_book(esmdata_preprocessed,
   idvar = "id",
   obsnovar = "obsno",
   focusvar = c("pos_aff", "neg_aff"),
   timevar = "start",
   validvar = "valid",
   obsno_max = 70,
   list_behaviors = c("min_date", "max_date", "nb_answer", "compliance"),
   list_stats = c("mean", "sd", "range", "n_length", "n_unique"),
   viz = list(c("ts", "hist"), c("ts", "hist"))
 )
}

}
