% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{gwodegree-ergmTerm}
\alias{gwodegree-ergmTerm}
\alias{InitErgmTerm.gwodegree}
\title{Geometrically weighted out-degree distribution}
\usage{
# binary: gwodegree(decay, fixed=FALSE, attr=NULL, cutoff=30, levels=NULL)
}
\arguments{
\item{decay}{nonnegative decay parameter for the outdegree frequencies; required if \code{fixed=TRUE} and ignored with a warning otherwise.}

\item{fixed}{optional argument indicating
whether the \code{decay} parameter is fixed at the given value, or is to be fit as a curved
exponential-family model (see Hunter and Handcock, 2006). The
default is \code{FALSE} , which means the scale parameter is not
fixed and thus the model is a curved exponential family.}

\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{cutoff}{This optional argument sets the number of underlying degree terms
to use in computing the statistics when \code{fixed=FALSE}, in order to reduce
the computational burden.  Its default value can also be controlled by the
\code{gw.cutoff} term option control parameter. (See \code{?control.ergm}.)}

\item{levels}{TODO (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
This term adds one network statistic to the model
equal to the weighted out-degree distribution with decay parameter
\code{decay} parameter, which should be positive. This
term can only be used with directed networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "gwodegree", "subsection")}
}
\concept{curved}
\concept{directed}
