% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yr_sort_range.R
\name{yr_extremes}
\alias{yr_extremes}
\alias{yr_earliest}
\alias{yr_latest}
\alias{yr_range}
\title{Chronological minima and maxima}
\usage{
yr_earliest(x, na.rm = FALSE)

yr_latest(x, na.rm = FALSE)

yr_range(x, na.rm = FALSE)
}
\arguments{
\item{x}{A \link{yr} vector with era}

\item{na.rm}{a logical indicating whether missing values should be removed}
}
\value{
For \code{yr_earliest()} and \code{yr_leatest()}, a \code{yr} vector of length 1 with the
earliest or latest value.

For \code{yr_range()}, a \code{yr} vector of length 2 with the earliest and latest
value (in that order).

If \code{x} contains \code{NA} values and \code{na.rm = FALSE} (the default), only \code{NA}s
will be returned.
}
\description{
Returns the chronologically earliest and/or latest value in a vector of
years, i.e. era-aware version \code{\link[=min]{min()}}, \code{\link[=max]{max()}}, and \code{\link[=range]{range()}}.
}
\details{
These are implemented as prefixed functions rather than S3 \code{\link[=min]{min()}}, \code{\link[=max]{max()}},
and \code{\link[=range]{range()}} methods for \link{yr}s to avoid surprises when numerical (i.e. not
chronological) extremes are expected.
}
\examples{
# Forward-counting era:
x <- yr(c(200, 100, 300), "CE")
yr_earliest(x)
yr_latest(x)
yr_range(x)

# Backward-counting era:
y <- yr(c(200, 100, 300), "BCE")
yr_earliest(y)
yr_latest(y)
yr_range(x)

}
\seealso{
Other functions for chronological ordering and extremes: 
\code{\link{yr_sort}()}
}
\concept{functions for chronological ordering and extremes}
