% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity-classes.R
\name{split.intensity}
\alias{split.intensity}
\title{Divide into groups and reassemble.}
\usage{
\method{split}{intensity}(x, f, drop = FALSE, ..., by, unit_size)
}
\arguments{
\item{x}{vector or data frame containing values to be divided into groups.}

\item{f}{a \sQuote{factor} in the sense that \code{\link[base]{as.factor}(f)}
    defines the grouping, or a list of such factors in which case their
    interaction is used for the grouping. If \code{x} is a data frame,
    \code{f} can also be a formula of the form \code{ ~ g} to split by
    the variable \code{g}, or more generally of the form \code{ ~ g1 +
      \dots + gk} to split by the interaction of the variables
    \code{g1}, \dots, \code{gk}, where these variables are evaluated in
    the data frame \code{x} using the usual non-standard evaluation
    rules.}

\item{drop}{logical indicating if levels that do not occur should be dropped
    (if \code{f} is a \code{factor} or a list).}

\item{...}{further potential arguments passed to methods.}

\item{by}{The name(s) of the variable(s) which define(s) the grouping.}

\item{unit_size}{Size of a group unit. It must be a named vector, with names
corresponding to non-observational variables (i.e. space and time
variables). If the size of a variable in the data set is not a multiple
of the provided value in \code{unit_size}, some sampling units (the last
ones) will be dropped so that clumps of individuals remain even
throughout the data set.}
}
\value{
A list of \code{\link{intensity}} objects.
}
\description{
Divide into groups and reassemble.
}
\examples{
my_incidence <- incidence(tomato_tswv$field_1929)
plot(my_incidence, type = "all")
my_incidence_spl1 <- split(my_incidence, by = "t")
my_incidence_spl2 <- split(my_incidence, unit_size = c(x = 8, y = 20, t = 1))

}
