% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter_db.R
\name{epiparameter_db}
\alias{epiparameter_db}
\title{Create \verb{<epiparameter>} object(s) directly from the epiparameter library
(database)}
\usage{
epiparameter_db(
  disease = "all",
  pathogen = "all",
  epi_name = "all",
  author = NULL,
  subset = NULL,
  single_epiparameter = FALSE
)
}
\arguments{
\item{disease}{A \code{character} string specifying the disease.}

\item{pathogen}{A \code{character} string specifying the pathogen.}

\item{epi_name}{A \code{character} string specifying the epidemiological
parameter. See details for full list of epidemiological distributions.}

\item{author}{A \code{character} string specifying the author of the study
reporting the distribution. Only the first author will be matched. It is
recommended to use the family name as first names may or may not be
initialised.}

\item{subset}{Either \code{NULL} or a valid R expressions that evaluates to
logicals to subset the list of \verb{<epiparameter>}, or a function that can be
applied over a list of \verb{<epiparameter>} objects.

Subsetting (using \code{subset}) can be combined with the subsetting done with
the \code{disease} and \code{epi_name} arguments (and \code{author} if specified). If left
as \code{NULL} (default) no subsetting is carried out.

The \code{subset} argument is similar to subsetting a \verb{<data.frame>}, but the
difference is that fixed comparisons and not vectorised comparisons are
needed. For example \code{sample_size > 10} is a valid subset expression, but
\code{sample_size == max(sample_size)}, which would be a valid subset expression
for a \verb{<data.frame>} does not work. The vectorised expression will often
not error, but will likely return unexpected results. For the
\code{sample_size == max(sample_size)} example it will always return \code{TRUE}
(except for \code{NA}s) as it is a single numeric so will be equal to it's
max value.

The expression should be specified without using the data object name
(e.g. \code{df$var}) and instead just \code{var} should be supplied. In
other words, this argument uses non-standard evaluation, just as the
\code{subset} argument in \code{\link[=subset]{subset()}}, and is similar to \verb{<data-masking>} used
by the \code{dplyr} package.}

\item{single_epiparameter}{A boolean \code{logical} determining whether a single
\verb{<epiparameter>} or multiple entries from the library can be returned if
matched by the other arguments (\code{disease}, \code{epi_name}, \code{author}). This
argument is used to prevent multiple sets of parameters being returned
when only one is wanted.

\strong{Note}: If multiple entries match the arguments supplied and
\code{single_epiparameter = TRUE} then the \verb{<epiparameter>} that is parameterised
(and accounts for truncation if available) and has the largest sample size
will be returned (see \code{\link[=is_parameterised]{is_parameterised()}}). If multiple entries are equal
after this sorting the first entry will be returned.}
}
\value{
An \verb{<epiparameter>} object or list of \verb{<epiparameter>} objects.
}
\description{
Extract \verb{<epiparameter>} object(s) directly from
the library of epidemiological parameters. The epiparameter
library of epidemiological parameters is compiled from primary literature
sources. The list output from \code{\link[=epiparameter_db]{epiparameter_db()}} can be subset by the data
it contains, for example by: disease, pathogen, epidemiological distribution,
sample size, region, etc.

If a distribution from a specific study is required, the \code{author} argument
can be specified.

Multiple entries (\verb{<epiparameter>} objects) can be returned, use the
arguments to subset entries and use \code{single_epiparameter = TRUE} to force a
single \verb{<epiparameter>} to be returned.
}
\details{
\code{disease}, \code{epi_name} and \code{author} are given as individual arguments
as these are the most common variables to subset the parameter library by.
The \code{subset} argument facilitates all other subsetting of rows to select the
\verb{<epiparameter>} object(s) desired. To subset based on multiple variables
separate each expression with \code{&}.

List of epidemiological parameters:
\itemize{
\item "all" (default, returns all entries in library)
\item "incubation period"
\item "onset to hospitalisation"
\item "onset to death"
\item "serial interval"
\item "generation time"
\item "offspring distribution"
\item "hospitalisation to death"
\item "hospitalisation to discharge"
\item "notification to death"
\item "notification to discharge"
\item "onset to discharge"
\item "onset to ventilation"
}
}
\examples{
epiparameter_db(disease = "influenza", epi_name = "serial_interval")

# example using custom subsetting
eparam <- epiparameter_db(
  disease = "SARS",
  epi_name = "offspring_distribution",
  subset = sample_size > 40
)

# example using functional subsetting
eparam <- epiparameter_db(
  disease = "COVID-19",
  epi_name = "incubation_period",
  subset = is_parameterised
)

# example forcing a single <epiparameter> to be returned
eparam <- epiparameter_db(
  disease = "SARS",
  epi_name = "offspring_distribution",
  single_epiparameter = TRUE
)
}
