% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getSubPop}
\alias{getSubPop}
\title{Get subpopulation}
\usage{
getSubPop(pop, ID)
}
\arguments{
\item{pop}{a valid object of class \code{Population}.}

\item{ID}{a vector giving the IDs of individuals to include in the
subset}
}
\value{
A new \code{Population} object containing the specified
  individuals is returned.
}
\description{
Retrieve a subset of a \code{Population} without recalculating effects
}
\details{
\code{getSubPop()} returns a new \code{Population} object using the
individuals with IDs specified by the vector \code{ID}.

Any additive and epistatic effects will be copied as-is to the new
\code{Population} object, with heritability parameters recalculated.

Any IDs given but not present will be discarded.
}
\examples{
\donttest{
# Construct a population with additive and epistatic effects
pop <- Population(
  popSize = 2000, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100)
)
pop <- addEffects(pop)
pop <- attachEpiNet(pop)

# Run the simulator
pop2 <- runSim(pop, generations = 10)

# Create a new subpopulation of 500 individuals
ID <- getComponents(pop2)$ID
ID <- sample(ID, 500)
pop3 <- getSubPop(pop2, ID)
}
}
\seealso{
\code{\link{Population}}, \code{\link{getComponents}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
