% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epichains.R
\name{.epichains}
\alias{.epichains}
\title{Create an \verb{<epichains>} object}
\usage{
.epichains(
  sim_df,
  n_chains,
  offspring_dist,
  track_pop,
  statistic = c("size", "length"),
  stat_threshold = Inf
)
}
\arguments{
\item{sim_df}{a \verb{<data.frame>} containing at least columns for
"infectee_id", "infector_id", and "generation". Also has optional columns
for "time", and "chain_id".}

\item{n_chains}{Number of chains to simulate.}

\item{offspring_dist}{Offspring distribution: a \verb{<function>} like the ones
provided by R to generate random numbers from given distributions (e.g.,
\code{\link{rpois}} for Poisson). More specifically, the function needs to
accept at least one argument, \code{n}, which is the number of random
numbers to generate. It can accept further arguments, which will be passed
on to the random number generating functions. Examples that can be provided
here are \code{rpois} for Poisson distributed offspring, \code{rnbinom} for negative
binomial offspring, or custom functions.}

\item{track_pop}{Was the susceptible population tracked? Logical.}

\item{statistic}{The chain statistic to track as the
stopping criteria for each chain being simulated when \code{stat_threshold} is not
\code{Inf}; A \verb{<string>}. It can be one of:
\itemize{
\item "size": the total number of cases produced by a chain before it goes
extinct.
\item "length": the total number of generations reached by a chain before
it goes extinct.
}}

\item{stat_threshold}{A stopping criterion for individual chain simulations;
a positive number coercible to integer. When any chain's cumulative statistic
reaches or surpasses \code{stat_threshold}, that chain ends. Defaults to \code{Inf}.
For example, if \code{statistic = "size"} and \code{stat_threshold = 10}, then any
chain that produces 10 or more cases will stop. Note that setting
\code{stat_threshold} does not guarantee that all chains will stop at the same
value.}
}
\value{
An \verb{<epichains>} object.
}
\description{
\code{epichains()} constructs an \verb{<epichains>} object, which is
inherently an \verb{<data.frame>} object that stores some of the inputs
passed to the \code{\link[=simulate_chains]{simulate_chains()}} and the
simulated output. The stored attributes are useful for downstream
analyses and reproducibility. This function checks the validity of the
object created to ensure it has the right columns and column types.

An \verb{<epichains>} object contains a \verb{<data.frame>} of the simulated
outbreak with ids for each infector and infectee, generation, and
optionally, time, the number of chains simulated,
the chain statistic that was tracked, and whether the susceptible
population was tracked.
}
\author{
James M. Azam
}
\keyword{internal}
