% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{.check_time_args}
\alias{.check_time_args}
\title{Check inputs that control time events}
\usage{
.check_time_args(tf_specified, tf, generation_time, t0)
}
\arguments{
\item{tf_specified}{\verb{<logical>}; Whether the \code{tf} argument is specified. Only
makes sense in the context where this function is called, i.e., in
\code{\link[=simulate_chains]{simulate_chains()}}. If \code{tf} is specified, generation_time must be specified.}

\item{tf}{A number for the cut-off for the infection times (if generation
time is given); Defaults to \code{Inf}.}

\item{generation_time}{The generation time function; the name
of a user-defined named or anonymous function with only one argument \code{n},
representing the number of generation times to sample.}

\item{t0}{Start time (if generation time is given); either a single value
or a vector of same length as \code{n_chains} (number of initial cases) with
corresponding initial times. Defaults to 0, meaning all cases started at
time 0.}
}
\value{
\code{NULL}; called for side effects
}
\description{
This function checks the time-related inputs, i.e., start time of each chain,
\code{t0}, the end time of the simulation, \code{tf}, and the generation time,
generation_time. It also checks that the generation_time argument is
specified if \code{tf} is specified as these go hand-in-hand.
}
\keyword{internal}
