% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographics.R
\name{describe_occupation}
\alias{describe_occupation}
\title{Get ISCO-88 occupation labels from codes}
\usage{
describe_occupation(isco_codes, sex = NULL, plot = NULL)
}
\arguments{
\item{isco_codes}{A numeric vector of ISCO-88 occupation codes
(major, submajor, minor, or unit)}

\item{sex}{A vector with the respective sex for isco_codes vector. The
default value is NULL}

\item{plot}{A type of plot between treemap and circular  packing. The default
value is NULL}
}
\value{
A string vector of ISCO-88 labels
}
\description{
Function that translates a vector of ISCO-88 occupation codes
into a vector of labels
}
\examples{
demog_data <- data.frame(
  occupation_label =
    c(6111, 3221, 5113, 5133, 6111, 23, 25),
  sex = c("F", "M", "F", "F", "M", "M", "F")
)
describe_occupation(
  isco_codes = demog_data$occupation_label,
  sex = demog_data$sex, plot = "treemap"
)
}
