% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_graficos.R
\encoding{UTF-8}
\name{epe4md_graf_pot_segmento}
\alias{epe4md_graf_pot_segmento}
\title{Gráfico da capacidade instalada acumulada por segmento}
\usage{
epe4md_graf_pot_segmento(dados, ano_inicio = 2013, tamanho = 14)
}
\arguments{
\item{dados}{data.frame. Resultados mensais de potência e energia.}

\item{ano_inicio}{numeric. Define o ano em que se inicia o eixo x. Default igual a 2013.}

\item{tamanho}{numeric. Altera tamanho da fonte da legenda. Default igual a 14.}
}
\description{
Mostra a soma acumulada da potência entre o intervalo de anos solicitado, agrupada entre os segmentos : ' Comercial (AT) ',
Comercial (BT) ', ' Comercial Remoto (AT/BT) ', ' Residencial ' e ' Residencial Remoto '.
}
\value{
Plota um gráfico que mostra a soma acumulada da potência entre o intervalo de anos solicitado, agrupada entre os segmentos : ' Comercial (AT) ', Comercial (BT) ', ' Comercial Remoto (AT/BT) ', ' Residencial ' e ' Residencial Remoto '.
}
\examples{

dados <- structure(
  list(data = structure(c(16953, 17167, 17532), class = "Date"),
       ano = c(2016, 2017, 2018),
       mes = c(6, 1, 1),
       nome_4md = c("RORAIMA", "RORAIMA", "RORAIMA"),
       subsistema = c("MAN", "MAN", "MAN"),
       uf = c("RR", "RR", "RR"),
       segmento = c("residencial", "residencial", "comercial_at"),
       fonte_resumo = c("Fotovoltaica", "Fotovoltaica", "Fotovoltaica"),
       energia_mwh = c(0.14901698211027, 0.31989258307487, 21.4846247221392),
       energia_autoc_mwh = c(0.0596067928441078, 0.127957033229948,
                             17.1876997777114),
       energia_inj_mwh = c(0.0894101892661617, 0.191935549844922,
                           4.29692494442784),
       energia_mwmed = c(Jun = 0.000206968030708708, Jan = 0.00042996314929418,
                         Jan = 0.0288771837663161),
       pot_mes_mw = c(0.00297, 0, 0),
       adotantes_mes = c(1, 0, 0),
       p = c(1e-04, 1e-04, 0.000122345127598721),
       q = c(0.779421829099793, 0.779421829099793, 1),
       regiao = c("N", "N", "N")),
  row.names = c(NA, -3L),
  class = c("tbl_df", "tbl", "data.frame")
)

graf_pot_segmento <- epe4md_graf_pot_segmento(
  dados = dados,
  ano_inicio = 2013,
  tamanho = 14
)

}
