% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{find.alpha}
\alias{find.alpha}
\title{Parameter \emph{alpha} for Quantiles of normal distribution based outlier detection - Only intended for developer use}
\usage{
find.alpha(x, alpha.start = 0.05, eps = NULL)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{alpha.start}{a numeric value giving the largest reasonable value of parameter \emph{alpha}.}

\item{eps}{a numeric value of the epsilon parameter. If \code{eps = NULL}, the value is calculated as recommended in Modified Algorithm A1 (Campulova et al., 2018).}
}
\value{
A numeric value giving the parameter \emph{alpha}
}
\description{
Finds the value of parameter \emph{alpha} defining the criterion for outlier identification using quantiles of normal distribution. The parameter is found using Modified algorithm A1 (Campulova et al., 2018.)
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function finds the value of parameter \emph{alpha} defining the criterion for outlier identification using quantiles of normal distribution. The algorithm is based on Modified Algorithm A1 described in (Campulova et al., 2018).
Nonoutliers are characterised as a homogeneous set of data randomly distributed around zero value.
The differences between the data correspond to random fluctuations in the measurements.
The algorithm finds the value of the parameter by scanning possible values of \emph{alpha} and investigating differences of the corresponding nonoutliers.
The idea is to choose alpha corresponding to the maximum change of the maximum difference found among the ordered nonoutlier data.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for finding outlier residuals based on quantiles of normal distribution.
}
\references{
Campulova M, Michalek J, Mikuska P, Bokal D (2018). Nonparametric algorithm for identification of outliers in environmental data. Journal of Chemometrics, 32, 453-463.
}
