% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{find.L}
\alias{find.L}
\title{Parameter L for Chebyshev inequality based outlier detection - Only intended for developer use}
\usage{
find.L(x, L.start = 2.5, eps = NULL)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{L.start}{a numeric value giving the smallest reasonable value of parameter \code{L}.}

\item{eps}{A numeric value of the \emph{epsilon} parameter. If \code{eps = NULL}, the value is calculated as recommended in Modified Algorithm A1 (Campulova et al., 2018).}
}
\value{
A numeric value giving the parameter \emph{L}
}
\description{
Finds the value of parameter L defining the criterion for outlier identification using Chebyshev inequality. The parameter is found using Algorithm A1 (Campulova et al., 2018).
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function finds the value of parameter L defining the criterion for outlier identification using Chebyshev inequality. The algorithm is based on Algorithm A1 described in (Campulova et al., 2018).
Nonoutliers are characterised as a homogeneous set of data randomly distributed around zero value.
The differences between the data correspond to random fluctuations in the measurements.
The algorithm finds the value of the parameter by scanning possible values of \emph{L} and investigating differences of the corresponding nonoutliers.
The idea is to choose \emph{L} corresponding to the maximum change of the maximum difference found among the ordered nonoutlier data.
The function is exported for developer use only. It does not perform any checks on inputs since it is only a convenience function for finding outlier residuals based on Chebyshev inequality.
}
\references{
Campulova M, Michalek J, Mikuska P, Bokal D (2018). Nonparametric algorithm for identification of outliers in environmental data. Journal of Chemometrics, 32, 453-463.
}
