% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremevalue.R
\name{extremal.index.censored}
\alias{extremal.index.censored}
\title{Extremal index estimation (Holesovsky and Fusek, 2020) - Only intended for developer use}
\usage{
extremal.index.censored(x, u, D)
}
\arguments{
\item{x}{a numeric vector of observations.}

\item{u}{a numeric value giving threshold.}

\item{D}{a nonnegative integer giving the value of D parameter (Holesovsky and Fusek, 2020)}
}
\value{
a numeric value of an extremal index estimate
}
\description{
Estimation of an extremal index using the censored estimator suggested in (Holesovsky and Fusek, 2020).
The function is called by \code{\link{KRDetect.outliers.EV}} and is not intended for use by regular users of the package.
}
\details{
This function computes the censored estimate of extremal index suggested in (Holesovsky and Fusek, 2020).
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function used within \code{\link{KRDetect.outliers.EV}}.
}
\references{
Holesovsky, J, Fusek, M (2020). Estimation of the Extremal Index Using Censored Distributions. Extremes, DOI: 10.1007/s10687-020-00374-3.
}
