% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlchart.R
\name{control.limits.R}
\alias{control.limits.R}
\title{Limits for control chart \emph{R} - Only intended for developer use}
\usage{
control.limits.R(x, group.size, L)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{group.size}{a positive integer giving the number of observations in individual segments used for computation of control chart limits.
If the data can not be equidistantly divided, the first extra values will be excluded from the analysis.}

\item{L}{a positive numeric value giving parameter \code{L} specifying the width of control limits.}
}
\value{
A list is returned with elements:
\item{x}{a numeric vector of data}
\item{range.est}{a numeric value giving an estimate of range parameter}
\item{groups.count}{a numeric value giving a number of segments used for estimating parameters of control chart}
\item{groups.range}{a numeric vector giving sample ranges in individual segments used for estimating parameters of control chart}
\item{LCL}{a numeric value giving lower control limit of control chart \emph{R}}
\item{UCL}{a numeric value giving upper control limit of control chart \emph{R}}
}
\description{
Estimation of limits of control chart \emph{R}. The function is called by \code{\link{KRDetect.outliers.controlchart}} and is not intended for use by regular users of the package.
}
\details{
This function computes parameters based on which control chart \emph{R} can be constructed.
The function is exported for developer use only. It does not perform any checks on inputs since it is only a convenience function for identification limits based on control chart \emph{R}.
}
\references{
Shewhart W (1931). Quality control chart. Bell System Technical Journal, 5, 593–603.

SAS/QC User's Guide, Version 8, 1999. SAS Institute, Cary, N.C.

Wild C, Seber G (2000). Chance encounters: A first course in data analysis and inference. New York: John Wiley.
}
