% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{EV.plot}
\alias{EV.plot}
\title{Extreme value outlier detection plot - Only intended for developer use}
\usage{
EV.plot(x, plot.type = "all", ...)
}
\arguments{
\item{x}{a list obtained as an output of function \code{\link{KRDetect.outliers.EV}} for identification of outliers using extreme value theory.}

\item{plot.type}{a type of plot with outliers displayed.

Possible options are
\itemize{
  \item{\code{"all"}} {to show outliers with both extremely low and high value}
  \item{\code{"min"}} {to show outliers with extremely low value}
  \item{\code{"max"}} {to show outliers with extremely high value}
}}

\item{...}{further arguments to be passed to the \code{\link{plot}} function.}
}
\description{
Plot of results obtained using function \code{\link{KRDetect.outliers.EV}} for identification of outliers using extreme value theory.
The function is called by \code{\link{plot.KRDetect}} and is not intended for use by regular users of the package.
}
\details{
This function plots the results obtained using function \code{\link{KRDetect.outliers.EV}} identificating outliers using changepoint analysis based method.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for plotting results obtained using functions implemented in package \pkg{envoutliers}.
}
