% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{check_object_exists}
\alias{check_object_exists}
\title{Check if an object exists in a given environment}
\usage{
check_object_exists(obj, envir = globalenv())
}
\arguments{
\item{obj}{object to check. It can be given as a symbol or as a string.}

\item{envir}{environment where the existence of \code{object} is checked.}
}
\value{
A list containing three elements:
\itemize{
\item{\code{found}} flag indicating whether the object was found
\item{\code{eval}} result of the evaluation of \code{obj} either in \code{envir} or in a parent environment
where it was found.
\item{\code{address}} memory address of the object found. IMPORTANT: This memory address is NOT the object's memory
address when the object is given as a string, as in that case the memory address contains the memory address of the
string! (which varies every time, even if the string is the same, because every time the string allocates a different
memory address)
}
}
\description{
Check if an object exists in a given environment or any parent environment from the given environment in
the way that the \link{eval} function does by default.
}
\details{
If the object is not found in the \code{envir} environment it is searched in any parent environment
of \code{envir}.
}
\keyword{internal}
