% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anno.R
\name{getalign}
\alias{getalign}
\title{Align two peaks vectors by mass to charge ratio and/or retention time}
\usage{
getalign(mz1, mz2, rt1 = NULL, rt2 = NULL, ppm = 10, deltart = 10)
}
\arguments{
\item{mz1}{the mass to charge of reference peaks}

\item{mz2}{the mass to charge of peaks to be aligned}

\item{rt1}{retention time of reference peaks}

\item{rt2}{retention time of peaks to be aligned}

\item{ppm}{mass accuracy, default 10}

\item{deltart}{retention time shift table, default 10 seconds}
}
\value{
data frame with aligned peaks table
}
\description{
Align two peaks vectors by mass to charge ratio and/or retention time
}
\examples{
mz1 <- c(221.1171, 227.1390, 229.1546, 233.1497, 271.0790 )
mz2 <- c(282.279, 281.113, 227.139, 227.139, 302.207)
rt1 <- c(590.8710, 251.3820, 102.9230, 85.8850, 313.8240)
rt2 <- c(787.08, 160.02, 251.76, 251.76, 220.26)
getalign(mz1,mz2,rt1,rt2)
}
