% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_max.R
\name{lambda_alpha_grid}
\alias{lambda_alpha_grid}
\title{Lambda Alpha Grid}
\usage{
lambda_alpha_grid(lambdas, alphas, nlambda = 10L, lmin_factor = 1e-04)
}
\arguments{
\item{lambdas}{a vector of max lambda values for each alpha given}

\item{alphas}{a vector of alpha values corresponding to the max lambdas}

\item{nlambda}{number of lambdas to generate for each alpha before creating the
grid}

\item{lmin_factor}{the smallest lambda value is defined as \code{lmin_factor
* max(lambda)} where \code{max(lambda)} is determined by this function.}
}
\description{
Construct a data frame with values for lambda and alpha with an indicator to
know if the model is worth fitting.
}
\examples{

data(tbi)
Xmat <- model.matrix( ~ . - injury1 - injury2 - injury3 - 1, data = tbi)
Yvec <- matrix(tbi$injury1, ncol = 1)
alphas <- seq(0, 1, length = 20)

lga <- lambda_alpha_grid(alphas = alphas, lambdas = lambda_max(Yvec, Xmat, alpha = alphas))

ggplot2::ggplot() +
  ggplot2::theme_bw() +
  ggplot2::aes_string(x = "a", y = "log10(l)") +
  ggplot2::geom_path(data = lga$top) +
  ggplot2::geom_point(data = lga$lgrid,
                      mapping = ggplot2::aes(color = cos(a) + sin(log10(l)))) +
  ggplot2::geom_contour(data = lga$lgrid,
                        mapping = ggplot2::aes(z = cos(a) + sin(log10(l)))) +
  ggplot2::scale_color_gradient2(low = "blue", high = "red", mid = "grey")

}
