% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countPoints.r
\name{countPoints}
\alias{countPoints}
\title{Number of points in a "spatial points" object}
\usage{
countPoints(x, byFeature = FALSE)
}
\arguments{
\item{x}{Object of class \code{sf} or \code{SpatVector}}

\item{byFeature}{If \code{FALSE}, return number of points for all features combined. If \code{TRUE}, report number of points per feature.}
}
\value{
Numeric.
}
\description{
Returns the number of points in a \code{sf} or \code{SpatVector} object. This is typically done using either \code{length(x)} or \code{nrow(x)}, depending on whether the object in question has rows or not. This function helps in ambiguous cases, so users need not care if \code{nrow} or \code{length} is needed.
}
\examples{

library(sf)

# lemur occurrence data
data(lemurs)
wgs84 <- getCRS('WGS84')
occs <- lemurs[lemurs$species == 'Eulemur fulvus', ]
occs <- sf::st_as_sf(occs, coords=c('longitude', 'latitude'), crs=wgs84)

countPoints(occs)

}
