% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-emuRtrackdata.R
\name{create_emuRtrackdata}
\alias{create_emuRtrackdata}
\title{create emuRtrackdata object}
\usage{
create_emuRtrackdata(sl, td)
}
\arguments{
\item{sl}{seglist of class \code{\link{emuRsegs}}}

\item{td}{\code{\link{trackdata}} object generated from sl}
}
\value{
emuRtrackdata object
}
\description{
Joins \code{\link{emuRsegs}} and \code{\link{trackdata}} objects
to create an \code{\link{emuRtrackdata}} object that is a sub-class of
a \code{\link{data.frame}} object. This object 
can be viewed as a flat version of a \code{\link{trackdata}} object that also 
contains all the information of a \code{\link{emuRsegs}} object. It is meant to
ease integration with other packages as it is based on the well known 
\code{\link{data.frame}} object.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# query emuDB (to get object of class emuRsegs)
sl = query(emuDBhandle = ae, 
           query = "Phonetic == i:")
           
# get formats for SEGMENTs in sl (to get object of class trackdata)
td = get_trackdata(emuDBhandle = ae, 
                   seglist = sl,
                   onTheFlyFunctionName = "forest")

# create emuRtrackdata object
create_emuRtrackdata(sl = sl, td = td)

}
}
