% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{hl_opts}
\alias{hl_opts}
\title{Create a set of options}
\usage{
hl_opts(
  na = getOption("HL_NA", "NA"),
  full_colour = getOption("HL_FULL_COLOUR", FALSE),
  text_mode = getOption("HL_TEXT_MODE", "contrast"),
  text_contrast = getOption("HL_TEXT_CONTRAST", 1)
)
}
\arguments{
\item{na}{Character string to display for NA values. Default 'NA'}

\item{full_colour}{Use 24bit ANSI escape codes?  default: FALSE - use 8bit colour.
Note: RStudio only supports 8 bit ANSI output (24bit ANSI is
rendered invisibly in Rstudio).  For 24bit colour output, try R in the terminal
e.g. 'iTerm' on OSX.}

\item{text_mode}{How to handle text if no text colour has been
explicitly specified by the user.
\describe{
\item{contrast}{(default) automatically select a contrasting colour for enhanced readability.}
\item{asis}{render text in the default text
     colour for the output device, unless the user has already specified
     a text colour at this location}
\item{remove}{remove all text without a user-defined colour}
}}

\item{text_contrast}{When \code{text_mode='contrast'} this numeric value in
range [0, 1] adjusts the visibility. Default: 1 (high contrast)}
}
\value{
named list of standard options
}
\description{
Create a set of options
}
\examples{
# Generate a standard set of options
hl_opts()
}
