% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.fitdist.R
\name{em.fitdist}
\alias{em.fitdist}
\title{The default em function}
\usage{
\method{em}{fitdist}(
  object,
  latent = 2,
  verbose = FALSE,
  init.method = c("random", "kmeans", "hc"),
  init.prob = NULL,
  algo = c("em", "cem", "sem"),
  max_iter = 500,
  ...
)
}
\arguments{
\item{object}{the model used, e.g. `lm`, `glm`, `gnm`.}

\item{latent}{the number of latent classes.}

\item{verbose}{`True` to print the process of convergence.}

\item{init.method}{the initialization method used in the model.
The default method is `random`. `kmeans` is K-means clustering.
`hc` is model-based agglomerative hierarchical clustering.}

\item{init.prob}{the starting prior probabilities used in classification based method.}

\item{algo}{the algorithm used in em: `em` the default EM algorithm,
the classification em `cem`, or the stochastic em `sem`.}

\item{max_iter}{the maximum iteration for em algorithm.}

\item{...}{arguments used in the `model`.}
}
\value{
An object of class `em` is a list containing at least the following components:
 \code{models} a list of models/objects whose class are determined by a model fitting from the previous step.  
 \code{pi} the prior probabilities.
 \code{latent} number of the latent classes.
 \code{algorithm} the algorithm used (could be either `em`, `sem` or `cem`).
 \code{obs} the number of observations.
 \code{post_pr} the posterior probabilities.
 \code{concomitant} a list of the concomitant model. It is empty if no concomitant model is used.
 \code{init.method} the initialization method used.
 \code{call} the matched call.
 \code{terms} the code{terms} object used.
}
\description{
The default em function
}
