% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.calc.R
\name{elo.calc}
\alias{elo.calc}
\alias{elo.calc.default}
\alias{elo.calc.formula}
\title{Post-update Elo values}
\usage{
elo.calc(wins.A, ...)

\method{elo.calc}{default}(wins.A, elo.A, elo.B, k, ..., adjust.A = 0, adjust.B = 0)

\method{elo.calc}{formula}(formula, data, na.action, subset, k = NULL, ...)
}
\arguments{
\item{wins.A}{Numeric vector of wins by team A.}

\item{...}{Other arguments (not in use at this time).}

\item{elo.A, elo.B}{Numeric vectors of elo scores.}

\item{k}{A constant k-value (or a vector, where appropriate).}

\item{adjust.A, adjust.B}{Numeric vectors to adjust \code{elo.A} and \code{elo.B} by.}

\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}
}
\value{
A data.frame with two columns, giving the new Elo values after each update.
}
\description{
Calculate post-update Elo values. This is vectorized.
}
\examples{
elo.calc(c(1, 0), c(1500, 1500), c(1500, 1600), k = 20)

dat <- data.frame(wins.A = c(1, 0), elo.A = c(1500, 1500),
                  elo.B = c(1500, 1600), k = c(20, 20))
elo.calc(wins.A ~ elo.A + elo.B + k(k), data = dat)
}
\seealso{
\code{\link{elo.prob}}, \code{\link{elo.update}},
  \code{elo.model.frame}
}
