% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richness-change.R
\name{richness_change}
\alias{richness_change}
\title{Calculate change in richness resulting from a percent reduction in flow}
\usage{
richness_change(stats, pctchg, xval = FALSE)
}
\arguments{
\item{stats}{A dataframe of ELF statistics}

\item{pctchg}{Decrease in flow as a percent (e.g. 10 equals 10 percent reduction in flow).}

\item{xval}{x-axis value for assessing percent change in richness. When supplied, the function will calculate percent change in richness at a specific stream size (e.g. 50 equals a stream size with mean annual flow of 50 cfs).}
}
\value{
Richness change value is returned
}
\description{
Calculates absolute or percent richness change from streamflow reduction
}
\examples{
\donttest{
# We don't run this example by R CMD check, because it takes >10s

watershed.df <- elfdata(watershed.code = '0208020104',
 ichthy.localpath = tempdir(), use_cache = FALSE)
breakpt <- 500
elf <- elfgen(
   "watershed.df" = watershed.df,
   "quantile" = 0.95,
   "breakpt" = breakpt,
   "xlabel" = "Mean Annual Flow (ft3/s)",
   "ylabel" = "Fish Species Richness"
   )
# Calculate absolute richness change
richness_change(elf$stats, "pctchg" = 10)
# Calculate percent richness change at a specific stream size
richness_change(elf$stats, "pctchg" = 10, "xval" = 50)
}
}
