% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyreformat.R
\name{polyreformat}
\alias{polyreformat}
\title{Reformat polytomous item responses in a long format for explanatory item response modeling}
\usage{
polyreformat(
  data,
  id.var,
  long.format = FALSE,
  var.name = "item",
  val.name = "resp"
)
}
\arguments{
\item{data}{A data frame -- either in a wide format where the rows represent persons and columns represent items
explanatory variables or in a long format where there are multiple rows for each person (i.e., nested data)}

\item{id.var}{The variable that represents examinee IDs.}

\item{long.format}{Whether the data follow a wide format and thus need to be transformed into a long format first (default is FALSE)}

\item{var.name}{The variable that represents item IDs if the data is already in long format; otherwise this is the
of the variable that represents item IDs once the data is transformed into long format.}

\item{val.name}{The variable that represents item responses if the data is already in long format;
otherwise this is the
of the variable that represents item responses once the data is transformed into long format.}
}
\value{
Reformatted data for explanatory item response modeling.
}
\description{
This function prepares the data with polytomous item responses for explanatory item response modeling.
If the data is already in a long format (i.e., items by person), it only recodes the polytomous responses
and creates a new variable to be used for the estimation. If the data is not in the long format, then both
reshaping the data into the long format and recoding items can be done simultaneously.
}
\examples{
data("VerbAgg")
VerbAgg2 <- polyreformat(data=VerbAgg, id.var = "id", long.format = FALSE,
var.name = "item", val.name = "resp")
head(VerbAgg2)
}
