% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.phreg.R
\name{plot.phreg}
\alias{plot.phreg}
\title{Plots output from a phreg regression}
\usage{
\method{plot}{phreg}(
  x,
  fn = c("haz", "cum", "den", "sur"),
  main = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Duration",
  ylab = "",
  col,
  lty,
  printLegend = TRUE,
  score = 1,
  fig = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{phreg} object}

\item{fn}{Which function should be plotted? Default is the hazard function(s).}

\item{main}{Header for the plot}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{xlab}{x label}

\item{ylab}{y label}

\item{col}{Color(s) for the curves. Defaults to black.}

\item{lty}{Line type for the curve(s). Defaults to 1:(No. of strata).}

\item{printLegend}{Logical, or character ("topleft", "bottomleft",
"topright" or "bottomright"); if \code{TRUE} or character, a legend is added
to the plot if the number of strata is two or more.}

\item{score}{Multiplication factor for the hazard function.}

\item{fig}{logical, should the graph be drawn? If FALSE, data is returned.}

\item{\dots}{Extra parameters passed to 'plot' and 'lines'.}
}
\value{
No return value if fig = TRUE, otherwise the cumulative 
hazards function (coordinates), given \code{fn = "cum"}.
}
\description{
Plot(s) of the hazard, density, cumulative hazards, and/or the survivor
function(s) for each stratum.
}
\note{
Reference hazard is given by the fit; 
zero for all covariates, and  the reference category for factors.
}
\examples{

y <- rllogis(40, shape = 1, scale = 1)
x <- rep(c(1,1,2,2), 10)
fit <- phreg(Surv(y, rep(1, 40)) ~ x, dist = "loglogistic")
plot(fit)

}
\seealso{
\code{\link{phreg}}
}
\author{
Göran Broström
}
\keyword{dplot}
\keyword{survival}
