% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pchreg.R
\name{pchreg}
\alias{pchreg}
\title{Piecewise Constant Proportional Hazards Regression}
\usage{
pchreg(
  formula = formula(data),
  data = parent.frame(),
  na.action = getOption("na.action"),
  cuts = NULL,
  init,
  control = list(eps = 1e-08, maxiter = 20, trace = FALSE),
  singular.ok = TRUE,
  model = FALSE,
  x = FALSE,
  y = TRUE
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~
operator, and the terms on the right.  The response must be a survival
object as returned by the Surv function.}

\item{data}{a data.frame in which to interpret the variables named in the
formula.}

\item{na.action}{a missing-data filter function, applied to the model.frame,
after any subset argument has been used.  Default is
\code{options()$na.action}.}

\item{cuts}{Specifies the points in time
where the hazard function jumps. If omitted, an exponential model is fitted.}

\item{init}{vector of initial values of the iteration.  Default initial
value is zero for all variables.}

\item{control}{a list with components \code{eps} (convergence criterion),
\code{maxiter} (maximum number of iterations), and \code{silent} (logical,
controlling amount of output).  You can change any component without mention
the other(s).}

\item{singular.ok}{Not used.}

\item{model}{Not used.}

\item{x}{Return the design matrix in the model object?}

\item{y}{Return the response in the model object?}
}
\value{
A list of class \code{"pchreg"} with components
\item{coefficients}{Fitted parameter estimates.} 
\item{cuts}{Cut points (\code{NULL} if no cut points).} 
\item{hazards}{The estimated constant levels.} 
\item{var}{Covariance matrix of the estimates.}
\item{loglik}{Vector of length two; first component is the value at the
initial parameter values, the second component is the maximized value.}
\item{score}{The score test statistic (at the initial value).}
\item{linear.predictors}{The estimated linear predictors.}
\item{means}{Means of the columns of the design matrix, except those columns
corresponding to a factor level. Otherwise all
zero.} 
\item{w.means}{Weighted (against exposure time) means of covariates;
weighted relative frequencies of levels of factors.} 
\item{n}{Number of
spells in indata (possibly after removal of cases with NA's).}
\item{n.events}{Number of events in data.} 
\item{terms}{Used by extractor functions.} 
\item{assign}{Used by extractor functions.} %
\item{wald.test}{The Wald test statistic (at the initial value).}
\item{y}{The Surv vector.} 
\item{isF}{Logical vector indicating the
covariates that are factors.} 
\item{covars}{The covariates.}
\item{ttr}{Total Time at Risk.} 
\item{levels}{List of levels of factors.}
\item{formula}{The calling formula.} 
\item{call}{The call.}
\item{method}{The method.} 
\item{convergence}{Did the optimization
converge?} 
\item{fail}{Did the optimization fail? (Is \code{NULL} if not).}
}
\description{
Proportional hazards model with piecewise constant baseline hazard(s).  Allows for
stratification and left truncated and right censored data.
}
\examples{

\dontrun{
dat <- age.window(oldmort, c(60, 80))
fit <- pchreg(Surv(enter, exit, event) ~ ses.50 + sex, 
data = dat, cuts = seq(60, 80, by = 4))
summary(fit)

fit.cr <- coxreg(Surv(enter, exit, event) ~ ses.50 + sex, data = dat)
check.dist(fit.cr, fit, main = "Cumulative hazards")
}

}
\seealso{
\code{\link{phreg}}, \code{\link{coxreg}}, \code{link{aftreg}}.
}
\author{
Göran Broström
}
\keyword{regression}
\keyword{survival}
