% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltx2.R
\name{ltx2}
\alias{ltx2}
\title{LaTeX alternative printing of regression results.}
\usage{
ltx2(
  x,
  caption = NULL,
  label = NULL,
  dr = NULL,
  digits = max(options()$digits - 4, 4),
  conf = 0.95,
  keep = NULL,
  ...
)
}
\arguments{
\item{x}{The output from a call to \code{coxreg}, \code{tpchreg}, or
\code{aftreg}}

\item{caption}{A suitable caption for the table.}

\item{label}{A label used in the LaTeX code.}

\item{dr}{Output from a \code{drop1} call.}

\item{digits}{Number of digits to be printed.}

\item{conf}{Confidence intervals level.}

\item{keep}{Number of covariates to present.}

\item{\dots}{Not used.}
}
\value{
LaTeX code version of the results from a run with
\code{\link{coxreg}}, \code{\link{phreg}}, \code{\link{phreg}}, 
\code{\link{aftreg}}.
}
\description{
This (generic) function prints the LaTeX code of the results of a fit from
\code{\link{coxreg}}, \code{\link{phreg}}, \code{\link{tpchreg}}, 
or \code{\link{aftreg}}.
}
\note{
Resulting tables contain estimated hazard ratios and confidence limits
instead of regression coefficients and standard errors as in \code{\link{ltx}}.
}
\examples{

data(oldmort)
fit <- coxreg(Surv(enter, exit, event) ~ sex, data = oldmort)
ltx2(fit, caption = "A test example.", label = "tab:test1") 

}
\seealso{
\code{xtable}, \code{\link{coxreg}}, \code{\link{phreg}}, 
\code{\link{phreg}}, \code{\link{aftreg}}, and \code{\link{ltx}}.
}
\author{
Göran Broström.
}
\keyword{printing}
