% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxfunk.R
\name{coxfunk}
\alias{coxfunk}
\title{Loglihood function (partial likelihood) of a Cox regression}
\usage{
coxfunk(beta, X, offset, rs, what = 2)
}
\arguments{
\item{beta}{Regression parameters}

\item{X}{The design (covariate) matrix.}

\item{offset}{Offset.}

\item{rs}{Risk set created by \code{risksets(..., collate_sets = TRUE)}}

\item{what}{what = 0 means only loglihood, 1 means score vector as well, 2
loglihood, score and hessian.}
}
\value{
A list with components 
\item{loglik}{The log likelihood.}
\item{dloglik}{The score vector. Nonzero if \code{what >= 1}}
\item{d2loglik}{The hessian. Nonzero if \code{ord >= 2}}
}
\description{
Calculates minus the log likelihood function and its first and second order
derivatives for data from a Cox regression model. It is used by \code{coxreg}
if the argument \code{coxph = FALSE}
}
\details{
Note that the function returns log likelihood, score vector and minus
hessian, i.e. the observed information. The model is
}
\seealso{
\code{\link{coxreg}}
}
\author{
Göran Broström
}
\keyword{distribution}
\keyword{survival}
