% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activationsOutcomes.R
\name{activationsOutcomes}
\alias{activationsOutcomes}
\title{Calculate the activations for all outcomes in the data.}
\usage{
activationsOutcomes(
  wmlist,
  data,
  split = "_",
  select.outcomes = NULL,
  init.value = 0,
  normalize = FALSE
)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}, 
or a single weightmatrix (matrix).}

\item{data}{Data frame with columns \code{Cues} and \code{Outcomes}. 
Number of rows should be the same as the number of weightmatrices 
in \code{wmlist}.}

\item{split}{String, separator between cues and/or outcomes.}

\item{select.outcomes}{Optional selection of outcomes to limit (or expand) 
the number of activations that are returned. 
The value of NULL (default) will 
return all activations (for each outcome in \code{data}). 
Note that specified values that are not in 
the weightmatrix will return the initial value without error or 
warning. Please use \code{\link{getValues}} for returning all 
outcomes in the data.}

\item{init.value}{Value of activations for non-existing connections. 
Typically set to 0.}

\item{normalize}{Logical: whether or not the activation is normalized by 
dividing the total activation by the number of cues. Default is FALSE. If 
set to TRUE, the activation reflects the average activation per cue.}
}
\value{
Vector or list of activation values (see \code{return.list} 
and \code{fun} for the specific conditions, and the examples below).
}
\description{
Calculate the activations for all outcomes in the data 
per learning event. The activation values are returned as data frame.
}
\section{Notes}{

The outcomes are selected based on the data with events, and not 
necessarily all outcomes present in the weightmatrices. For example, 
when the weightmatrices were first trained on another data set, some 
outcomes may be present in the weightmatrices but not in the current 
training data. To include these as well, the user can specify these 
extra outcomes with the argument \code{select.outcomes}.
}

\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)

# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)
head(train)

# this training data can actually be used train network:
wm <- RWlearning(train)

# Now we calculate the activations for all outcomes
# per event:
activations <- activationsOutcomes(wm, train)
head(activations)

# Now with selection of outcomes (note that 'dog' does
# not occur as outcome in the data):
activations2 <- activationsOutcomes(wm, train, 
    select.outcomes = c("plant", "vehicle", "dog"))
head(activations2)
tail(activations2)

}
\seealso{
\code{\link{getWeightsByCue}},
\code{\link{getWeightsByOutcome}}

Other functions for calculating activations: 
\code{\link{activationsCueSet}()},
\code{\link{activationsEvents}()},
\code{\link{activationsMatrix}()},
\code{\link{getActivations}()}
}
\author{
Jacolien van Rij
}
\concept{functions for calculating activations}
