% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_rcrds}
\alias{simulate_rcrds}
\title{Simulate records}
\usage{
simulate_rcrds(.data, ..., .seed = NULL, .nsim = 1L)
}
\arguments{
\item{.data}{An edibble data}

\item{...}{A name-value pair where the name should correspond to the names
used in the \code{\link[=simulate_process]{simulate_process()}}. The value should be returned from calling
\code{\link[=with_params]{with_params()}}.}

\item{.seed}{An optional seed value.}

\item{.nsim}{The number of times to simulate data.}
}
\description{
Simulate records
}
\examples{
design() \%>\%
 set_units(unit = 4) \%>\%
 set_trts(trt = 2) \%>\%
 allot_table(trt ~ unit) \%>\%
 set_rcrds(y = unit) \%>\%
 simulate_process(y = function() {
            res <- rnorm(n())
            res
 }) \%>\%
 simulate_rcrds(y = with_params(), .nsim = 3)


}
