% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adult_coefs.R
\docType{data}
\name{adult_rxc}
\alias{adult_rxc}
\title{Adult Rx Condition Factors - Table 9}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
10 rows and 7 columns
\describe{
\item{used}{Whether or not the category is used in the RA model}
\item{plat, gold, silver, bronze, cat}{HCC grouping risk score for each
metal level}
\item{rxc}{RXC label for risk scores (Includes leading zeroes)}
}
}
\source{
Data import and cleaning at:
\url{https://github.com/EeethB/edgedata/tree/main/data-raw}
}
\usage{
adult_rxc
}
\description{
A dataset containing the adult model prescription drug category (RXC)
factors for the risk adjustment model. Rx condition categories are
triggered by NDC codes (See \code{\link{ndc_rxc}}) or HCPCS codes (See
\code{\link{hcpcs_rxc}}), and a hierarchy is then applied (See
\code{\link{rxc_hier}}).
}
\seealso{
Other factors: 
\code{\link{adult_demo}},
\code{\link{adult_enroll_dur}},
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{child_demo}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{infant_demo}},
\code{\link{infant_mat_sev}}

Other RXC tables: 
\code{\link{adult_rxc_hcc_inter}},
\code{\link{hcpcs_rxc}},
\code{\link{ndc_rxc}},
\code{\link{rxc_hier}}
}
\concept{RXC tables}
\concept{factors}
\keyword{datasets}
