% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\title{Estimate ED50}
\usage{
estimate(doseSequence, doseResponse, confidence = 0.95,
  method = c("Dixon-Mood", "Choi", "ModTurPoint", "Logistic",
  "Isotonic"), tpCiScale = 1, boot.n = 2000)
}
\arguments{
\item{doseSequence}{A sequence of doses given in order}

\item{doseResponse}{A sequence of response results shown in order}

\item{confidence}{The confidence level of interval estimate}

\item{method}{The method used to estimate ED50, there are five methods here, respectively
Dixon-Mood, Choi (Choi's Original Turning Point), ModTurPoint (Modified Turning Point),
Logistic (Logistic Regression) and Isotonic (Isotonic Regression). The defaut is Dixon-Mood.}

\item{tpCiScale}{The scale level to enlarge the confidence interval estimated by Modified
Turning Point Method. The default value is \code{1}.}

\item{boot.n}{The number of boot process if Logistic method is chosen to estimate ED50.}
}
\value{
A list of estimation result consisting of method of estimation, ED50 estimate,
standard error of ED50 estimate, confidence level and estimate of confidence interval.
The return value of the function is a list consisting of the method used Method of Estimation', 
the estimation of the ed50 value'Estimate of ED50', the standard error of the estimation'Standard Error of Estimate', 
the confidence level 'Confidence Level' and the lower and the upper bound of the confidence interval 'Lower Bound'&
'Upper Bound'. For Dixon-Mood estimation, the value of the parameter G will also be given as 'Value of Parameter G' in the list.
}
\description{
Estimate 50 percent effective dose using different methods.
}
\examples{
library(ed50simulation)
estimate(groupS$doseSequence, groupS$responseSequence, method = 'Dixon-Mood')
estimate(groupS$doseSequence, groupS$responseSequence, method = 'Logistic', boot.n = 1000)
}
\references{
Dixon, W. J., & Mood, A. M. (1948) <doi:10.1080/01621459.1948.10483254>. A method for obtaining and analyzing
sensitivity data. Publications of the American Statistical Association, 43(241), 109-126.
Choi, S. C. (1990)<doi:10.2307/2531453>. Interval estimation of the ld50based on an up-and-down experiment.
Biometrics, 46(2), 485-492.
Pace, N. L., & Stylianou, M. P. (2007)<doi:10.1097/01.anes.0000267514.42592.2a>. Advances in and limitations of up-and-down
methodology: a precis of clinical use, study design, and dose estimation in anesthesia
research. Anesthesiology, 107(1), 144-52.
}
