% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.toLatex.R
\name{toLatex}
\alias{toLatex}
\alias{toLatex.list}
\alias{toLatex.data.frame}
\title{Export results of statistical tests to LaTeX table(s).}
\usage{
toLatex(
  stats,
  stat.cols = NULL,
  probs = NULL,
  type = "by.instance",
  cell.formatter = NULL
)

\method{toLatex}{list}(
  stats,
  stat.cols = NULL,
  probs = NULL,
  type = "by.instance",
  cell.formatter = NULL
)

\method{toLatex}{data.frame}(
  stats,
  stat.cols = NULL,
  probs = NULL,
  type = "by.instance",
  cell.formatter = NULL
)
}
\arguments{
\item{stats}{[\code{list}]\cr
Data frame (return value of \code{\link{computeIndicators}}) or named list of list as returned by \code{test}.}

\item{stat.cols}{[\code{character}]\cr
Names of the indicators to consider.
Defaults to all indicators available in \code{stats}.}

\item{probs}{[\code{character}]\cr
Filtering: vector of problem instances. This way one can restrict the
size of the table(s).
Defaults to all problems available in \code{stats}.
Ignored if \code{stats} is a data frame.}

\item{type}{[\code{character(1)}]\cr
Type of tables. At the moment only option \dQuote{by.instance} is available.
I.e., a separate LaTeX-table is generated for each instance specified via \code{probs}.
Ignored if \code{stats} is a data frame.}

\item{cell.formatter}{[\code{function(cell, ...)}]\cr
Function which is used to format table cells. This function is applied to each
table cell and may be used to customize the output. Default is \code{niceCellFormater}.
Ignored if \code{stats} is a data frame.}
}
\value{
[\code{list}] Named list of strings (LaTeX tables). Names correspond to the
  selected problem instances in \code{probs}.
}
\description{
Returns high-quality LaTeX-tables of the test results of
statistical tests performed with function \code{test}
on per-instance basis. I.e., a table is returned for each instances combining
the results of different indicators.
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{approximateRefSets}()},
\code{\link{computeDominanceRanking}()},
\code{\link{emoaIndEps}()},
\code{\link{makeEMOAIndicator}()},
\code{\link{niceCellFormater}()},
\code{\link{normalize}()},
\code{\link{plotDistribution}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{plotScatter3d}()}
}
\concept{EMOA performance assessment tools}
