% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.selector.dominatedHypervolume.R
\name{selDomHV}
\alias{selDomHV}
\title{Dominated Hypervolume selector.}
\usage{
selDomHV(fitness, n.select, ref.point)
}
\arguments{
\item{fitness}{[\code{matrix}]\cr
Matrix of fitness values (each column contains the fitness value(s) of one
individual).}

\item{n.select}{[\code{integer(1)}]\cr
Number of elements to select.}

\item{ref.point}{[\code{numeric}]\cr
Reference point for hypervolume computation.}
}
\value{
[\code{integer}] Vector of survivor indizes.
}
\description{
Performs non-dominated sorting and drops the individual from the last front
with minimal hypervolume contribution. This selector is the basis of the
S-Metric Selection Evolutionary Multi-Objective Algorithm, termed SMS-EMOA
(see \code{\link{smsemoa}}).
}
\note{
Note that the current implementation expects \code{n.select = ncol(fitness) - 1}
and the selection process quits with an error message if \code{n.select} is greater
than 1.
}
\seealso{
Other selectors: 
\code{\link{selGreedy}()},
\code{\link{selNondom}()},
\code{\link{selRanking}()},
\code{\link{selRoulette}()},
\code{\link{selSimple}()},
\code{\link{selTournament}()}
}
\concept{selectors}
