% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.mutator.bitflip.R
\name{mutBitflip}
\alias{mutBitflip}
\title{Bitplip mutator.}
\usage{
mutBitflip(ind, p = 0.1)
}
\arguments{
\item{ind}{[\code{binary}]\cr
Binary vector, i.e., vector with elements 0 and 1 only.}

\item{p}{[\code{numeric(1)}]\cr
Probability to flip a single bit.
Default is \code{0.1}.}
}
\value{
[\code{binary}]
}
\description{
This operator works only on binary representation and flips each bit
with a given probability \eqn{p \in (0, 1)}. Usually it is recommended to
set \eqn{p = \frac{1}{n}} where \eqn{n} is the number of bits in the
representation.
}
\references{
[1] Eiben, A. E. & Smith, James E. (2015). Introduction to Evolutionary
Computing (2nd ed.). Springer Publishing Company, Incorporated. 52.
}
\seealso{
Other mutators: 
\code{\link{mutGauss}()},
\code{\link{mutInsertion}()},
\code{\link{mutInversion}()},
\code{\link{mutJump}()},
\code{\link{mutPolynomial}()},
\code{\link{mutScramble}()},
\code{\link{mutSwap}()},
\code{\link{mutUniform}()}
}
\concept{mutators}
