% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.dataprocessing.R
\name{explode}
\alias{explode}
\alias{implode}
\title{Explode/implode data frame column(s).}
\usage{
explode(df, col, by = ".", keep = FALSE, col.names = NULL)

implode(df, cols, by = ".", keep = FALSE, col.name)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data frame.}

\item{col}{[\code{character(1)}]\cr
Name of column which should be exploded.}

\item{by}{[\code{character(1)}]\cr
Delimeter used to split cell entries (for \code{explode}) or
glue them together (for \code{implode}).}

\item{keep}{[\code{logical(1)}]\cr
Should exploded or imploded source column be kept?
Default is \code{FALSE}.}

\item{col.names}{[\code{character}]\cr
Names of new columns.
Default is \dQuote{\code{col}.1}, ..., \dQuote{\code{col}.k}, where
k is the number of elements each cell in column \code{col} is split into.}

\item{cols}{[\code{character(1)}]\cr
Names of columns (or column number) which should be imploded.}

\item{col.name}{[\code{character(1)}]\cr
Name of new column.}
}
\value{
[\code{data.frame}] Modified data frame.
}
\description{
Given a data frame and a column name, function
\code{explode} splits the content of a column by a specified
delimiter (thus exploded) into multiple columns. Function \code{implode}
does vice versa, i.e., given a non-empty set of column names or
numbers, the function glues together the columns. Hence, functions
\code{explode} and \code{implode} are kind of inverse to each other.
}
\examples{
df = data.frame(x = 1:3, y = c("a.c", "a.b", "a.c"))
df.ex = explode(df, col = "y", col.names = c("y1", "y2"))
df.im = implode(df.ex, cols = c("y1", "y2"), by = "---", col.name = "y", keep = TRUE)
}
