% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_moments_ecp.R
\name{ecp_kmoment_cond}
\alias{ecp_kmoment_cond}
\title{The conditional k-th moment of extended Chen-Poisson distribution}
\usage{
ecp_kmoment_cond(x, k, lambda, gamma, phi)
}
\arguments{
\item{x}{vector of quantiles.}

\item{k}{a positive integer.}

\item{lambda, gamma}{parameter values > 0.}

\item{phi}{parameter value != 0.}
}
\value{
Estimated value of conditional k-th moment, based on numerical
integration, using the function integrate.
}
\description{
Computes the conditional k-th moment of the extended Chen-Poisson (ecp)
distribution.
}
\details{
The conditional k-th moment of a distribution is given by E(X^k | X > x). To
obtain this value for the Extended Chen-Poisson distribution, it is necessary
to use numerical integration. For that purpose, the R function 'integrate()'
can be used (see details about function 'integrate()'). Note that when k = 1
and x = 0, the conditional moment is equal to the expected value, i.e.,
E(X | X > 0) = E(X).
}
\examples{
ecp_kmoment_cond(x = 0, k = 1, lambda = .1, gamma = .5, phi = - .2)

}
