% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments_ecp.R
\name{ecp_kmoment}
\alias{ecp_kmoment}
\title{The k-th raw moment of extended Chen-Poisson distribution}
\usage{
ecp_kmoment(k, lambda, gamma, phi)
}
\arguments{
\item{k}{a positive integer.}

\item{lambda, gamma}{parameter values > 0.}

\item{phi}{parameter value != 0.}
}
\value{
Estimated value of k-th raw moment, based on numerical integration,
as well as integral absolute error obtained from the function integrate.
}
\description{
Computes the k-th raw moment of the extended Chen-Poisson (ecp) distribution.
}
\details{
To obtain the value of k-th raw moment of the Extended Chen-Poisson
distribution, it is necessary to use numerical integration. For that purpose,
the R function 'integrate()' can be used, which returns the estimated value
of the integral and also the integral absolute error (see details about
function 'integrate()'). Therefore, to obtain the variance, the first
component of each k-th raw moments must be selected.
}
\examples{
ecp_kmoment(k = 1, lambda = .1, gamma = .5, phi = - .2) # First raw moment.
ecp_kmoment(k = 2, lambda = .1, gamma = .5, phi = - .2) # Second raw moment.
ecp_kmoment(k = 2, lambda = .1, gamma = .5, phi = - .2)[1] -
ecp_kmoment(k = 1, lambda = .1, gamma = .5, phi = - .2)[1]^2 # Variance.

}
