% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ecotoxicology.R
\name{Probitw}
\alias{Probitw}
\title{Calculate weighting coefficient from expected probit}
\usage{
Probitw(Y, C = 0)
}
\arguments{
\item{Y}{numeric, expected probit}

\item{C}{numeric, proportion of natural mortality}
}
\value{
the weighting coefficient
}
\description{
Returns the weighting coefficient from expected probit
}
\examples{
# Example from page 90 of Finney 1964:
# expected probit Y = 6.2, control mortality C = 59\%
Y <- 6.2
C <- 0.59
# weighting coefficient = 0.141
Probitw(Y,C)
}
\author{
Jose Gama
}
\references{
Finney D. J., 1964
Probit analysis: a statistical treatment of the sigmoid response curve.
Cambridge University Press. Formula 6.3.
}

