% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ecotoxicology.R
\name{ProbitWorkingP}
\alias{ProbitWorkingP}
\title{Calculate working probit}
\usage{
ProbitWorkingP(Y, p)
}
\arguments{
\item{Y}{numeric, expected probit}

\item{p}{numeric, kill percentage}
}
\value{
the working probit
}
\description{
Returns the working probit
}
\examples{
# Example from page 50 of Finney 1964:
# kill p = 72.3\%, expected probit Y = 6.2
Y <- 6.2
p <- 72.3/100
# working probit = 5.366
ProbitWorkingP(Y,p)
}
\author{
Jose Gama
}
\references{
Finney D. J., 1964
Probit analysis: a statistical treatment of the sigmoid response curve.
Cambridge University Press
}

