% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ecotoxicology.R
\name{CalculateLC50}
\alias{CalculateLC50}
\title{Calculate LC50 from a matrix with 3 columns: concentration, number of exposed subjects and number of deaths}
\usage{
CalculateLC50(matrixConcExpoResp)
}
\arguments{
\item{matrixConcExpoResp}{numeric vector}
}
\value{
the LC50
}
\description{
Returns the LC50 from a matrix with 3 columns: concentration, number of exposed subjects and number of deaths
}
\examples{
#Data from the example on page 5:
#Hamilton, m.a., R.c. Russo, and r.v. Thurston, 1977.
#Trimmed spearman-karber method for estimating median
#Lethal concentrations in toxicity bioassays.
#Environ. Sci. Technol. 11(7): 714-719;
#Correction 12(4):417 (1978).
concentration<-c(.5,1,2,4,8)
exposed<-c(10,10,10,10,10)
mortality<-c(0,2,4,9,10)
CalculateLC50(cbind(concentration, exposed, mortality))
}
\author{
Jose Gama
}
\references{
Hamilton, m.a., R.c. Russo, and r.v. Thurston, 1977.
Trimmed spearman-karber method for estimating median
Lethal concentrations in toxicity bioassays.
Environ. Sci. Technol. 11(7): 714-719;
Correction 12(4):417 (1978).
}

