% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{plot.pcfamily}
\alias{plot.pcfamily}
\title{Plot Phase Curve Family}
\usage{
\method{plot}{pcfamily}(
  x,
  model_var_label = NULL,
  model_var_color = NULL,
  facet_grid_label = NULL,
  facet_paras = TRUE,
  ...
)
}
\arguments{
\item{x}{object of class "\code{pcfamily}" that represents a phase curve family.}

\item{model_var_label}{a list indicating labels of model variables. Name should
be old variable names and values should be names of labels.}

\item{model_var_color}{a list indicating colors of model variable. Name should
be old variable names and values should be 16-bit color codes.}

\item{facet_grid_label}{a list indicating facet labels. Name should be old
variable names and values should be facet labels.}

\item{facet_paras}{a logical vector indicating whether facet?}

\item{...}{other parameters}
}
\value{
a graphic object
}
\description{
Creates a plot of a phase curve family.
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2, constraint = c("x<1", "y<1"))
value_space <- list(x = c(0.2, 0.3, 0.4), y = 0.1, a11 = 1:3)
plot(eode_sensitivity_proj(x, valueSpace = value_space, N = 100))
}
