% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_request.R, R/wf_request_batch.R
\name{wf_request}
\alias{wf_request}
\alias{wf_request_batch}
\title{ECMWF Data Store (DS) request and download}
\usage{
wf_request(
  request,
  user = "ecmwfr",
  transfer = TRUE,
  path = tempdir(),
  time_out = 3600,
  retry = 30,
  job_name,
  verbose = TRUE
)

wf_request_batch(
  request_list,
  workers = 2,
  user = "ecmwfr",
  path = tempdir(),
  time_out = 3600,
  retry = 5,
  total_timeout = length(request_list) * time_out/workers
)
}
\arguments{
\item{request}{nested list with query parameters following the layout
as specified on the ECMWF APIs page}

\item{user}{user (default = "ecmwf") provided by the ECMWF data service,
used to retrieve the token set by \code{\link[ecmwfr]{wf_set_key}}}

\item{transfer}{logical, download data TRUE or FALSE (default = TRUE)}

\item{path}{path were to store the downloaded data}

\item{time_out}{how long to wait on a download to start (default =
\code{3600} seconds).}

\item{retry}{polling frequency of submitted request for downloading (default =
\code{30} seconds).}

\item{job_name}{optional name to use as an RStudio job and as output variable
name. It has to be a syntactically valid name.}

\item{verbose}{show feedback on processing}

\item{request_list}{a list of requests that will be processed in parallel.}

\item{workers}{maximum number of simultaneous request that will be submitted
to the service. Most ECMWF services are limited to 20 concurrent requests
(default = 2).}

\item{total_timeout}{overall timeout limit for all the requests in seconds.}
}
\value{
the path of the downloaded (requested file) or the an R6 object
with download/transfer information
}
\description{
Stage a data request, and optionally download the data to disk. Alternatively
you can only stage requests, logging the request URLs to submit download
queries later on using \code{\link[ecmwfr]{wf_transfer}}.
Note that the function will do some basic checks on the \code{request} input
to identify possible problems.
}
\examples{

\dontrun{
# set key
wf_set_key(key = "123")

request <- list(
  dataset_short_name = "reanalysis-era5-pressure-levels",
  product_type = "reanalysis",
  variable = "geopotential",
  year = "2024",
  month = "03",
  day = "01",
  time = "13:00",
  pressure_level = "1000",
  data_format = "grib",
  target = "download.grib"
)

# demo query
wf_request(request = request)

# Run as an RStudio Job. When finished, will create a
# variable named "test" in your environment with the path to
# the downloaded file.
wf_request(request = request, job_name = "test")
}
}
\seealso{
\code{\link[ecmwfr]{wf_set_key}}
\code{\link[ecmwfr]{wf_transfer}}
}
\author{
Koen Hufkens
}
