% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fable.R
\name{reservoir}
\alias{reservoir}
\title{Return the reservoir from a trained ESN as tibble}
\usage{
reservoir(object)
}
\arguments{
\item{object}{An object of class \code{mdl_df}, containing an ESN model.}
}
\value{
A tibble containing the reservoir (internal states).
}
\description{
Return the reservoir (internal states) from a
  trained ESN as tibble. The function works only for models
  of class \code{ESN}.
}
\examples{
library(tsibble)
library(fable)
AirPassengers \%>\%
as_tsibble() \%>\%
model("ESN" = ESN(value)) \%>\%
reservoir()

}
