% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.band}
\alias{ecr.band}
\title{Area band}
\usage{
ecr.band(df = NULL, lower = NULL, upper = NULL, type = "polygon", ...)
}
\arguments{
\item{df}{A data.frame with lower and upper numerical columns and first column with X coordinates.}

\item{lower}{The column name of band's lower boundary (string).}

\item{upper}{The column name of band's upper boundary (string).}

\item{type}{Type of rendering
\itemize{
\item 'polygon' - by drawing a polygon as polyline from upper/lower points (default)
\item 'stack' - by two \href{https://echarts.apache.org/en/option.html#series-line.stack}{stacked lines}
}}

\item{...}{More attributes for \href{https://echarts.apache.org/en/option.html#series-line.type}{serie}}
}
\value{
A list of \strong{one serie} when type='polygon', or list of \strong{two series} when type='stack'
}
\description{
A 'custom' serie with lower and upper boundaries
}
\details{
\itemize{
\item type='polygon': coordinates of the two boundaries are chained into one polygon.\cr
\verb{     } \emph{xAxis type} could be 'category' or 'value'.\cr
\verb{     } Set fill color with attribute \emph{color}.
\item type='stack': two \emph{stacked} lines are drawn, the lower with customizable areaStyle.\cr
\verb{     } \emph{xAxis type} should be 'category' ! \cr
\verb{     } Set fill color with attribute \emph{areaStyle$color}.\cr
\verb{     } Optional tooltip formatter available in \emph{band[[1]]$tipFmt}.
}
Optional parameter \emph{name}, if given, will show up in legend. Legend merges all series with same name into one item.
}
\examples{
set.seed(222)
df <- data.frame( x = 1:10, y = round(runif(10, 5, 10),2)) |>
  dplyr::mutate(lwr= round(y-runif(10, 1, 3),2), upr= round(y+runif(10, 2, 4),2) )
banda <- ecr.band(df, 'lwr', 'upr', type='stack', name='stak', areaStyle= list(color='green'))
#banda <- ecr.band(df, 'lwr', 'upr', type='polygon', name='poly1')

df |> ec.init( load='custom', # polygon only
  legend= list(show= TRUE),
  xAxis= list(type='category', boundaryGap=FALSE), # stack
  #xAxis= list(scale=T, min='dataMin'),            # polygon 
  series= append(
    list(list(type='line', color='blue', name='line1')),
    banda
  ),
  tooltip= list(trigger='axis', formatter= banda[[1]]$tipFmt)
)

}
