% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_DB_pulls.R
\name{dbPull}
\alias{dbPull}
\title{Pull data from a relational data base.}
\usage{
dbPull(vSelect = NULL, filePath)
}
\arguments{
\item{vSelect}{Character vector of variables that should be pulled from data base. If \code{vSelect} is \code{NULL}, all variables from the data base are selected.}

\item{filePath}{Path to an the existing db file.}
}
\value{
Returns a data frame, including the selected variables.
}
\description{
Function to extract specific variables from various data tables. Variables are merged in the specified merge order via left joins and using the foreign keys. If variables are selected from a specific data table, the corresponding primary keys are also always extracted. If no variables from the first data tables in the \code{mergeOrder} are selected, these data tables are skipped (up till the first variable - data table match). If only variables of a single data table are selected, this data table is extracted with all variables and sub setting is performed in \code{R}.
}
\details{
Note that the exact merging process is determined when the data base is created via \code{\link{createDB}} and can not be altered post hoc. Further options (e.g. filtering cases, full joins) are still under development. If you want to use the package and have specific requests, please contact the package author.
}
\examples{
db_path <- system.file("extdata", "example_dataBase.db", package = "eatDB")

## Extract variables from the first data table by name
# primary and foreign keys are added as required
dat1 <- dbPull(vSelect = c("age"), filePath = db_path)

## Extract all variables from the first data table
varNames <- dbNames(db_path)
dat2 <- dbPull(vSelect = varNames$NoImp, filePath = db_path)

## Extract variables from different data table (merged automatically)
dat3 <- dbPull(vSelect = c("weight", "noBooks", "pv"), filePath = db_path)

## Extract all variables from the data base
dat4 <- dbPull(filePath = db_path)

}
