% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq.R
\name{eq}
\alias{eq}
\title{NA-Friendly Equality Comparison}
\usage{
eq(x, y, do.nanull.equal = TRUE)
}
\arguments{
\item{x}{First vector/value for comparison.}

\item{y}{Second vector/value for comparison.}

\item{do.nanull.equal}{Return TRUE if both inputs are NA or NULL (tested via easyr::nanull).}
}
\value{
Boolean vector/value of comparisons.
}
\description{
Vectorized flexible equality comparison which considers NAs as a value. Returns TRUE if both values are NA, and FALSE when only one is NA. 
The standard == comparison returns NA in both of these cases and sometimes this is interpreted unexpectedly.
Author: Bryce Chamberlain. Tech Review: Maria Gonzalez.
}
\examples{
c(NA,'NA',1,2,'c') == c(NA,NA,1,2,'a') # regular equality check.
eq(c(NA,'NA',1,2,'c'),c(NA,NA,1,2,'a')) # check with eq.
}
