% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCC.R
\name{sampleCC}
\alias{sampleCC}
\title{Create Subsample of a Simulated Chronocoulogram}
\usage{
sampleCC(filename, data.reduction = 1)
}
\arguments{
\item{filename}{The filename that contains the result of a simulated chronocoulometry experiment (created using the \code{ccSim} function).}

\item{data.reduction}{A value that gives the percentage of the original data to keep, which then is spaced evenly across the full data set.}
}
\value{
Returns a list with the following components \item{expt}{type of experiment; CC for a chronocoulometry experiment} \item{file_type}{value that indicates whether the output includes all data (full) or a subset of data (reduced); defaults to reduced} \item{charge}{vector giving the charge as a function of time} \item{time}{vector giving the time}
}
\description{
Used to create a reduced data file of times and currents for a chronocoulogram. When passed to plotCC, the resulting plot shows the data as discrete points instead of as a line.
}
\examples{
ex_ca = simulateCA(e.start = 0.25, e.pulse = -0.25, e.form = 0,
  pulses = "double", t.2 = 20, x.units = 100, t.units = 1000)
ex_cc = simulateCC(ex_ca)
ex_ccsample = sampleCC(ex_cc, data.reduction = 5)
str(ex_ccsample)
}
